import es
import vecmath
from playerlib import getPlayer

class BnB(object):
    class Player(object):
        def __init__(self, userid):
            self.userid = userid
            self.player = getPlayer(userid)
        
        def setNoBlock(self):
            if not self.isdead:
                nearest = self.player.getClosestPlayer(2 if self.team == 3 else 3)
                if nearest[0] is not None:
                    distance = vecmath.distance(vecmath.vector(es.getplayerlocation(self.userid)), vecmath.vector(es.getplayerlocation(nearest[1])))
                    if distance <= 110:
                        self.player.noblock(0)
                    else:
                        self.player.noblock(1)
        
        @property
        def properties(self):
            return es.createplayerlist(self.userid)[int(self.userid)]
        
        @property
        def team(self):
            return self.properties['teamid']
        
        @property
        def isdead(self):
            return self.properties['isdead']
    
    def __init__(self):
        self.players = {}
    
    def insertUserid(self, userid):
        self.players[str(userid)] = self.Player(userid)
    
    def removeUserid(self, userid=0, clear=False):
        if not clear:
            del self.players[userid]
        else:
            self.players.clear()
    
    def scriptLoad(self):
        for userid in es.getUseridList():
            self.insertUserid(userid)
        es.addons.registerTickListener(self._tickListener)
    
    def scriptUnload(self):
        self.removeUserid(clear=True)
        es.addons.unregisterTickListener(self._tickListener)
    
    def _tickListener(self):
        for userid in self.players:
            self.players[userid].setNoBlock()

bnb = BnB()

def player_activate(ev):
    bnb.insertUserid(ev['userid'])

def player_disconnect(ev):
    bnb.removeUserid(ev['userid'])

def load():
    bnb.scriptLoad()

def unload():
    bnb.scriptUnload()
